#version 330

#ifdef _UV
uniform sampler2D Tex0;
#endif
#ifdef _DIFFUSE
uniform vec4 diffuse;
#endif

#ifdef _NORMAL
in vec3 norm;
#endif
#ifdef _UV
in vec2 uv;
#endif
#ifdef _VCOLOR
in vec4 vcolor;
#endif

out vec4 fragColor;

void main()
{
	vec4 color = vec4(1.0, 1.0, 1.0, 1.0);
#ifdef _UV
	color *= texture(Tex0, uv.xy);
#endif
#ifdef _DIFFUSE
	color *= diffuse;
#endif
#ifdef _VCOLOR
	color *= vcolor;
#endif
#ifdef _RIM
	vec3 N = normalize(norm);
	color *= vec4(1.0, 1.0, 1.0, clamp((1.0 - N.z)*0.3 + 0.3, 0.0, 1.0));
#endif

    fragColor = color;
}
